/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.provider.rs6k;

import com.ibm.hsc.cim.provider.rs6k.CimomWrapper;
import com.ibm.hsc.cim.provider.rs6k.HWBPAReqHandler;
import com.ibm.hsc.cim.provider.rs6k.HWSvrReqHandler;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.frame.BPAClientExt;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.CIMClass;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.client.CIMOMHandle;

public class HWSvrReqListener
extends Thread {
    private CIMOMHandle mCIMOMHandle;
    private static Hashtable mListeners = new Hashtable();
    private Hashtable mRunningReqs = null;
    private Hashtable mBPARunningReq = null;
    private Hashtable mPortMTMSmap = null;

    public static HWSvrReqListener getInstance(CIMOMHandle cIMOMHandle) {
        HWSvrReqListener hWSvrReqListener = (HWSvrReqListener)mListeners.get(cIMOMHandle);
        if (hWSvrReqListener == null) {
            hWSvrReqListener = new HWSvrReqListener(cIMOMHandle);
            mListeners.put(cIMOMHandle, hWSvrReqListener);
        }
        return hWSvrReqListener;
    }

    public CIMOMHandle getCIMOMHandle() {
        return this.mCIMOMHandle;
    }

    private HWSvrReqListener(CIMOMHandle cIMOMHandle) {
        this.mCIMOMHandle = cIMOMHandle;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Socket socket = null;
        DataInputStream dataInputStream = null;
        DataOutputStream dataOutputStream = null;
        int n = 0;
        byte[] byArray = new byte[2];
        byte[] byArray2 = null;
        while (socket == null) {
            boolean bl = false;
            while (!bl) {
                try {
                    socket = new Socket(InetAddress.getLocalHost(), 9734);
                    bl = true;
                }
                catch (IOException iOException) {
                    HSCLogUtils.serverLog(iOException, HSCLogUtils._CIMClientDaemonClassLogInfo);
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        HSCLogUtils.serverLog(interruptedException, HSCLogUtils._CIMClientDaemonClassLogInfo);
                        interruptedException.printStackTrace();
                    }
                }
            }
            this.mRunningReqs = new Hashtable();
            this.mBPARunningReq = new Hashtable();
            this.mPortMTMSmap = new Hashtable();
            System.out.println("created socket to HW server");
            try {
                try {
                    dataInputStream = new DataInputStream(socket.getInputStream());
                    dataOutputStream = new DataOutputStream(socket.getOutputStream());
                    dataOutputStream.writeShort(65281);
                    dataOutputStream.flush();
                    Trace.trace("acldhscT", "-> Connected to LCE");
                    while (true) {
                        dataInputStream.readFully(byArray);
                        short s = (short)(((byArray[0] & 0xFF) << 8) + (byArray[1] & 0xFF));
                        s = (short)(s - 1);
                        byArray2 = new byte[s];
                        n = dataInputStream.readUnsignedByte();
                        dataInputStream.readFully(byArray2);
                        System.out.println("opcode:" + n + " message:" + new String(byArray2, 0, byArray2.length - 1));
                        int n2 = 0;
                        while (n2 < byArray2.length) {
                            System.out.println("message[" + n2 + "] = 0x" + Integer.toHexString(byArray2[n2]));
                            ++n2;
                        }
                        if (n == 207 || n == 239) {
                            this.handleBPAReq(n, byArray2);
                            continue;
                        }
                        String string = n + "%" + new String(byArray2, 0, byArray2.length - 1);
                        Short s2 = (Short)this.mRunningReqs.get(string);
                        if (s2 != null) {
                            this.mRunningReqs.put(string, new Short(1));
                            System.out.println("duplicate request " + string + " pending.");
                            continue;
                        }
                        System.out.println("new request " + string + " starting handler.");
                        this.mRunningReqs.put(string, new Short(0));
                        HWSvrReqHandler hWSvrReqHandler = new HWSvrReqHandler(n, byArray2, this);
                        hWSvrReqHandler.start();
                    }
                }
                catch (IOException iOException) {
                    Object var14_15;
                    System.out.println("HW socket broke");
                    HSCLogUtils.serverLog(iOException, HSCLogUtils._CIMClientDaemonClassLogInfo);
                    try {
                        try {
                            System.out.println("Close HW conn");
                            socket.close();
                            socket = null;
                            System.out.println("LCESocket closed.");
                            dataInputStream.close();
                            dataOutputStream.close();
                            this.mPortMTMSmap.clear();
                        }
                        catch (IOException iOException2) {
                            HSCLogUtils.serverLog(iOException2, HSCLogUtils._CIMClientDaemonClassLogInfo);
                            iOException2.printStackTrace();
                            var14_15 = null;
                            this.clearBPA();
                            continue;
                        }
                        var14_15 = null;
                        this.clearBPA();
                    }
                    catch (Throwable throwable) {
                        var14_15 = null;
                        this.clearBPA();
                        throw throwable;
                    }
                }
            }
            catch (Throwable throwable) {
                try {
                    try {
                        System.out.println("Close HW conn");
                        socket.close();
                        socket = null;
                        System.out.println("LCESocket closed.");
                        dataInputStream.close();
                        dataOutputStream.close();
                        this.mPortMTMSmap.clear();
                    }
                    catch (IOException iOException) {
                        HSCLogUtils.serverLog(iOException, HSCLogUtils._CIMClientDaemonClassLogInfo);
                        iOException.printStackTrace();
                        Object var18_22 = null;
                        this.clearBPA();
                    }
                    Object var18_21 = null;
                    this.clearBPA();
                }
                catch (Throwable throwable2) {
                    Object var18_23 = null;
                    this.clearBPA();
                    throw throwable2;
                }
                throw throwable;
            }
        }
    }

    public Hashtable getRunningReqs() {
        return this.mRunningReqs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleBPAReq(int n, byte[] byArray) {
        System.out.println("handles bpa req, opcode: " + n);
        long l = this.getBPAPortNum(byArray);
        Long l2 = new Long(l);
        String string = null;
        if (n == 207) {
            string = this.getBPAMTMS(l);
            if (string != null) {
                this.mPortMTMSmap.put(l2, string);
            }
        } else {
            string = (String)this.mPortMTMSmap.get(l2);
            if (string != null) {
                this.mPortMTMSmap.remove(l2);
            }
        }
        System.out.println("port: " + l + " mtms: " + string);
        if (string == null) {
            return;
        }
        Hashtable hashtable = this.mBPARunningReq;
        synchronized (hashtable) {
            HWBPAReqHandler hWBPAReqHandler = (HWBPAReqHandler)this.mBPARunningReq.get(string);
            if (hWBPAReqHandler == null) {
                hWBPAReqHandler = new HWBPAReqHandler(string, n, l, this);
                this.mBPARunningReq.put(string, hWBPAReqHandler);
                hWBPAReqHandler.start();
            } else {
                hWBPAReqHandler.addAction(n, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishBPAHandling(String string) {
        Hashtable hashtable = this.mBPARunningReq;
        synchronized (hashtable) {
            this.mBPARunningReq.remove(string);
        }
    }

    private long getBPAPortNum(byte[] byArray) {
        System.out.println("message[3]: " + byArray[3]);
        System.out.println("message[2]: " + byArray[2]);
        System.out.println("message[1]: " + byArray[1]);
        System.out.println("message[0]: " + byArray[0]);
        long l = 255L;
        long l2 = 0xFFFFFFFFL;
        System.out.println("port & message[3]: " + (l &= (long)byArray[3]));
        l = ((byArray[3] & 0xFF) << 24) + ((byArray[2] & 0xFF) << 16) + ((byArray[1] & 0xFF) << 8) + (byArray[0] & 0xFF);
        System.out.println("port: " + (l &= l2));
        return l;
    }

    private String getBPAMTMS(long l) {
        try {
            String string = BPAClientExt.getInstance().getBpaMtms(l);
            System.out.println("mtms: " + string);
            if (string != null && string.trim().equals("")) {
                System.out.println("!!cannot get frame mtms");
                return null;
            }
            return string;
        }
        catch (Throwable throwable) {
            HSCLogUtils.serverLog(throwable, HSCLogUtils._CIMClientDaemonClassLogInfo);
            throwable.printStackTrace();
            System.out.println("cannot get frame mtms");
            return null;
        }
    }

    private void clearBPA() {
        System.out.println("lost connection with HW server");
        CIMObjectPath cIMObjectPath = null;
        CIMClass cIMClass = null;
        try {
            cIMObjectPath = new CIMObjectPath("IBMHSC_Frame", "root/ibmhscV3_2");
            cIMClass = this.mCIMOMHandle.getClass(cIMObjectPath, false);
        }
        catch (Throwable throwable) {
            HSCLogUtils.serverLog(throwable, HSCLogUtils._CIMClientDaemonClassLogInfo);
            throwable.printStackTrace();
            return;
        }
        Vector vector = null;
        try {
            vector = CimomWrapper.enumInstances(this.mCIMOMHandle, cIMObjectPath, false, cIMClass);
        }
        catch (Throwable throwable) {
            HSCLogUtils.serverLog(throwable, HSCLogUtils._CIMClientDaemonClassLogInfo);
            throwable.printStackTrace();
        }
        if (vector == null) {
            return;
        }
        System.out.println("num of frames exist: " + vector.size());
        CIMValue cIMValue = new CIMValue(new Vector(), new CIMDataType(25));
        int n = 0;
        while (n < vector.size()) {
            CIMObjectPath cIMObjectPath2 = (CIMObjectPath)vector.elementAt(n);
            try {
                System.out.println("objPath: " + cIMObjectPath2);
                this.mCIMOMHandle.setProperty(cIMObjectPath2, "PortNum", cIMValue);
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._CIMClientDaemonClassLogInfo);
                throwable.printStackTrace();
            }
            ++n;
        }
    }
}

